var includesPath = "photo";

function getWindowHeight() {
    if (document.body)
    {
	return (document.body.offsetHeight);
    }
    else
    {
	return (window.innerHeight);
    }
}

function getWindowWidth() {
    if (document.body)
    {
	return (document.body.offsetWidth);
    }
    else
    {
	return (window.innerWidth);
    }
}

function displayLoad(id) {
    var container = document.getElementById(id);
    var divLoad = document.createElement("div");
    divLoad.setAttribute("style", "position : relative; float : left; min-width : 100%; min-height : 100%; background-color : grey; background-image : url(includes/data/img/ajax-loader.gif); background-repeat : no-repeat; background-position : center; opacity : 0.4;");
    container.appendChild(divLoad);
}

function getStyleCss(rule) {
    var style = document.styleSheets;
    var rules;
    //alert(style.length);
    for(var i = 0; i < style.length; i++) {
	if (style[i].cssRules)
	    rules = style[i].cssRules;
	else
	    rules = style[i].rules;
	//alert(rules.length);
	for (var j = 0; j < rules.length; j++) {
	//    alert(rules[j].selectorText);
	    if (rules[j].selectorText.toLowerCase() == rule)
		return rules[j];
	}
	//if (rules[rule])
	//    return rules[rule];
    }
    return false;
}

function displayBigSizePhoto(id, start, end, photo, index, path, width, height, duration) {
    var container = document.getElementById(id);
    var divRefPos = container.parentNode;
    var div = document.createElement('div');
    var img = document.createElement('img');
    var divFake = document.createElement('div');
    var rule = null;

    while (divRefPos.nodeName != "BODY") {

	if(((rule = getStyleCss("#"+divRefPos.id)) && rule.style.position == "absolute") ||
	   ((rule = getStyleCss("."+divRefPos.class))  && rule.style.position == "absolute") ||
	   ((rule = getStyleCss(divRefPos.nodeName)) && rule.style.position == "absolute")) {
	    break;
	}
	divRefPos = divRefPos.parentNode;
    }

    var wWidth = divRefPos.offsetWidth;
    var wHeight = divRefPos.offsetHeight;

    img.onclick = function () { div.style.display="none"; };
    img.id = "imgOriginal";
    img.src = path;
    img.alt = path;
    img.style.display = "none";

    var exif = document.createElement('div');
    var divPrev = document.createElement('div');
    var divNext = document.createElement('div');
    var divNavigation = document.createElement('div');

    var prevOnClick = function () {
	img.style.opacity = 0;
	getAjaxFile(includesPath+"/includes/php/interfaces/functionText.php?method=getNextPath&serializedphoto="+photo+"&index="+(--index), 
		    null, 
		    "GET", 
		    null, 
		    callback);
    };
    var nextOnClick = function () {
	img.style.opacity = 0;
	getAjaxFile(includesPath+'/includes/php/interfaces/functionText.php?method=getNextPath&serializedphoto='+photo+'&index='+(++index), 
		    null, 
		    "GET", 
		    null, 
		    callback); 
    };
    var callback = function(text) { 
	var elems = text.split('\n');
	img.src = elems[0];
	img.onload = function () { fade (img.id, 1); };
	getAjaxFile(includesPath+"/includes/php/interfaces/functions.php?method=createExifDataDiv&serializedphoto="+elems[1], "exifDiv", "GET", null);
	if (index >= end-1) {
	    divNext.style.backgroundImage = "url("+includesPath+"/includes/data/img/no-next.png)";
	    divNext.style.cursor = "";
	    divNext.onclick = null;
	}
	else {
	    divNext.style.backgroundImage = "url("+includesPath+"/includes/data/img/next.png)";
	    divNext.style.cursor = "pointer";
	    divNext.onclick = nextOnClick;
	}

	if (index <= 0) {
	    divPrev.style.backgroundImage = "url("+includesPath+"/includes/data/img/no-prev.png)";
	    divPrev.style.cursor = "";
	    divPrev.onclick = null;
	}
	else {
	    divPrev.style.backgroundImage = "url("+includesPath+"/includes/data/img/prev.png)";
	    divPrev.style.cursor = "pointer";
	    divPrev.onclick = prevOnClick;
	}
	
    };

    divPrev.id = "prevImg";
    divPrev.style.cssFloat= "left";
    divPrev.style.width = "40px";
    divPrev.style.height = "40px";
    divPrev.style.backgroundColor = "red";
    divPrev.style.backgroundRepeat = "no-repeat";
    divPrev.style.backgroundPosition = "center";
    divPrev.style.left = "0px";
    divPrev.style.opacity = 0;
    divPrev.style.zIndex = 1;

    if (index <= start) {
	divPrev.style.backgroundImage = "url("+includesPath+"/includes/data/img/no-prev.png)";
    }
    else {
	divPrev.style.cursor = "pointer";
	divPrev.onclick = prevOnClick;
	divPrev.style.backgroundImage = "url("+includesPath+"/includes/data/img/prev.png)";
    }

    divNext.id = "nextImg";
    divNext.style.cssFloat = "right";
    divNext.style.width = "40px";
    divNext.style.height = "40px";
    divNext.style.backgroundColor = "blue";
    divNext.style.backgroundRepeat = "no-repeat";
    divNext.style.backgroundPosition = "center";
    divNext.style.opacity = 0;
    divNext.style.zIndex = 1;

    if ((index+1) >= end) {
	divNext.style.backgroundImage = "url("+includesPath+"/includes/data/img/no-next.png)";
    }
    else {
	divNext.style.cursor = "pointer";
	divNext.onclick = nextOnClick;
	divNext.style.backgroundImage = "url("+includesPath+"/includes/data/img/next.png)";
    }

    divFake.style.position = "absolute";
    divFake.style.width = "100%";
    divFake.style.height = "40px";
    divFake.onclick = function () { div.style.display="none"; };
    divFake.appendChild(document.createTextNode(" "));

    divNavigation.style.position = "absolute";
    divNavigation.style.width = "100%";
    divNavigation.style.height = "40px";
    divNavigation.style.top = "50%";
    divNavigation.appendChild(divFake);
    divNavigation.appendChild(divPrev);
    divNavigation.appendChild(divNext);

    exif.setAttribute('id', 'exifDiv');
    exif.style.position = "absolute";
    exif.style.width = "100%";
    exif.style.overflow = "hidden";
    exif.style.opacity = 0;

    div.setAttribute('id', 'photoDiv');
    div.style.position = "absolute";
    div.style.height =  (height / 2) + "px";
    div.style.width =  (width / 2) + "px";
    div.style.top = ((wHeight - parseInt(div.style.height)) / 2) + "px";
    div.style.left = ((wWidth - parseInt(div.style.width)) / 2) + "px";
    div.style.backgroundColor = "#000000";
    div.style.backgroundImage = "url("+includesPath+"/includes/data/img/ajax-loader.gif)";
    div.style.backgroundPosition = "center";
    div.style.backgroundRepeat = "no-repeat";

    div.onmouseover = function () { fade (exif.id, .8); fade (divPrev.id, .8); fade (divNext.id, .8); };
    div.onmouseout = function () { fade (exif.id, 0); fade (divPrev.id, 0); fade (divNext.id, 0); };

    if (document.getElementById('photoDiv')) {
	container.removeChild(document.getElementById('photoDiv'));
    }
    
    div.appendChild(exif);
    div.appendChild(img);
    div.appendChild(divNavigation);
    container.appendChild(div);

    getAjaxFile(includesPath+"/includes/php/interfaces/functions.php?method=createExifDataDiv&serializedphoto="+photo, "exifDiv", "GET", null);

    animateBigSizePhoto(div.id, wWidth, wHeight, width, height, duration, false);
}

function animateBigSizePhoto (id, wWidth, wHeight, width, height, duration, up) {
    var div = document.getElementById(id);
    
    if (parseInt(div.style.height) < height) {
	div.style.height = (parseInt(div.style.height) + (height / (duration / 2))) + "px";
	div.style.top = ((((wHeight - parseInt(div.style.height)) / 2) < 10)?10:((wHeight - parseInt(div.style.height)) / 2)) + "px";
    } else {
	if (isNaN(parseInt(div.style.height))) {
	    div.style.height = (height / 2)+"px";
	    div.style.top = ((((wHeight - parseInt(div.style.height)) / 2) < 10)?10:((wHeight - parseInt(div.style.height)) / 2)) + "px";
	}
	else {
	    up = !up;
	}
    }
    
    if (up) {
	if (parseInt(div.style.width) < width) {
	    div.style.width = (parseInt(div.style.width) + (width / (duration / 2))) + "px";
	    div.style.left = ((wWidth - parseInt(div.style.width)) / 2) + "px";
	} else {
	    if (isNaN(parseInt(div.style.width))) {
		div.style.width = (width / 2) + "px";
		div.style.left = ((wWidth - parseInt(div.style.width)) / 2) + "px";
	    }
	}
    }
    
    if (parseInt(div.style.height) >= height && parseInt(div.style.width) >= width) {
	div.childNodes[1].style.display = "";
	div.style.height = "";
	div.style.width = "";
	return;
    }
    else {
	setTimeout("animateBigSizePhoto('"+id+"', "+wWidth+", "+wHeight+","+width+","+height+","+duration+", "+up+")", 1);
    }
}

function zoomThumbnail(idImg, newWidth, newHeight, m) {
    var img = document.getElementById(idImg);
    img.parentNode.style.margin = m+"px"; 
    img.parentNode.style.width = newWidth+"px";
    img.parentNode.style.height = newHeight+"px"; 
    img.nextSibling.nextSibling.style.width = newWidth + "px",
    img.style.width = newWidth+"px";
    img.style.height = newHeight+"px";

    if (newWidth == 160)
	img.nextSibling.nextSibling.style.visibility = "visible";
    else
	img.nextSibling.nextSibling.style.visibility = "hidden";
}

function ajuste(id) {

    var div = document.getElementById(id);
    var nodes = div.childNodes;
    var max = 0;

    for (var i=0; i < nodes.length; i++) {
	if (nodes[i].nodeType == 1) {
	    if (nodes[i].offsetHeight > max) {
		max = nodes[i].offsetHeight;
	    }
	}
    }

    for (var j=0; j < nodes.length; j++) {
	if (nodes[j].nodeType == 1) {
	    nodes[j].style.height = max + "px";
	}
    }
}

var fadingArray = new Array;

function fade (id, o) {
    if (fadingArray[id]) {
	fadingArray[id].stopFade();
	fadingArray[id] == null;
    }
    fadingArray[id] = new Fadable(id, o);
    fadingArray[id].startFade();
}

function execFadeInterval (id) {
    fadingArray[id].timer = setInterval("fadingArray['"+id+"'].execFade()", 1);
}

function Fadable (id, o) {
    this.id = id;
    this.elt = document.getElementById(id);
    this.o = o;
    this.timer = null;
    this.execFade = function (){
	if (this.o == parseFloat(this.elt.style.opacity)) {
	    this.elt.style.opacity = parseFloat(this.o);
	    clearInterval(this.timer);
	    this.timer = null;
	}
	else if (this.o > parseFloat(this.elt.style.opacity)) {
	    this.elt.style.opacity = parseFloat(this.elt.style.opacity) + 0.02;
	}
	else if (this.o < parseFloat(this.elt.style.opacity)) {
	    this.elt.style.opacity = parseFloat(this.elt.style.opacity) - 0.02;
	}
    };
    this.startFade = function () {
	if (this.timer != null)
	    clearInterval(timer);
	execFadeInterval(this.id);
    }
    this.stopFade = function () {
	if (this.timer != null)
	    clearInterval(this.timer);
	this.timer = null;
    }
}