<?php
class Photo {
  var $name;
  var $album;
  var $height;
  var $width;

  function Photo($n, $a, $h, $w) {
    $this->name = $n;
    $this->album = $a;
    $this->height = $h;
    $this->width = $w;
  }

  function GetPath() {
    return $this->album->GetPath().$this->name;
  }

  function GetRelativePath() {
    return $this->album->path."/".$this->name;
  }

  function GetThumbnailPath() {
    return Parameter::$absoluteThumbnailPath.$this->album->GetListAlbumName()."/".$this->GetBaseName().".jpg";
  }

  function GetHistogramPath() {
    return Parameter::$absoluteThumbnailPath.$this->album->GetListAlbumName()."/".$this->GetBaseName()."_histo.jpg";
  }

  function GetRelativeThumbnailPath() {
    return Parameter::$relativeThumbnailPath.$this->album->GetListAlbumName()."/".$this->GetBaseName().".jpg";
  }

  function GetRelativeHistogramPath() {
    return Parameter::$relativeThumbnailPath.$this->album->GetListAlbumName()."/".$this->GetBaseName()."_histo.jpg";
  }

  function GetThumbnailFolder() {
    return Parameter::$absoluteThumbnailPath.$this->album->GetListAlbumName();
  }

  function GetRelativeThumbnailFolder() {
    return Parameter::$relativeThumbnailPath.$this->album->GetListAlbumName();
  }

  function GetBaseName() {
    return substr($this->name, 0, strripos($this->name, "."));
  }

  function GetType() {
    return substr($this->name, strripos($this->name, "."));
  }
}
?>
