<?php

include 'thumbnail.php';

function getListPhoto($album) {
  $MyDirectory = scandir($album->path) or die('Erreur');
  $arrayFile = array();
  $arrayDir = array();
  $indexDir = 0;
  $indexFile = 0;
  $sizePhoto;
  for($i = 0; $i < count($MyDirectory); $i++) {
    if (is_dir($album->path."/".$MyDirectory[$i])) {
      if ($MyDirectory[$i] != "." && $MyDirectory[$i] != "..") {
	$arrayDir[$indexDir] = new Album($album->path."/".$MyDirectory[$i], $MyDirectory[$i], $album);
	$indexDir++;
      }
    } else {
      if (substr($MyDirectory[$i], 0, 1) != '.') {
	$sizePhoto = getimagesize($album->path."/".$MyDirectory[$i]);
	$arrayFile[$indexFile] = new Photo($MyDirectory[$i], $album, $sizePhoto[1], $sizePhoto[0]);
	$indexFile++;
      }
    }
  }
  sort($arrayDir);
  sort($arrayFile);
  return array_merge($arrayDir, $arrayFile);
}

function generateThumbnails($album, $start = -1, $length = -1) {
  $listPathPhoto = getListPhoto($album);
  if ($start >= 0)
    $listPathPhoto = array_slice($listPathPhoto, $start, $length);
  for ($i = 0; $i < count($listPathPhoto); $i++) {
    if(get_class($listPathPhoto[$i]) == "Album")
      generateThumbnails($listPathPhoto[$i], -1);
    else {
      createThumbnail($listPathPhoto[$i]);
      createHistogram($listPathPhoto[$i]);
    }
  }
  return true;
}

function getNextPath($photo, $index) {
  $listPathPhoto = getListPhoto($photo->album);
  return $listPathPhoto[$index]->getPath()."\n".serialize($listPathPhoto[$index]);
}

function createAdminForm($album, $start, $end, $photoPerLine) {
  echo "<div id='adminForm' style='position : absolute; margin : 0 auto 0 auto; background-color : red;'>";
  echo "<form action='javascript:getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=createList&amp;serializedalbum=".addslashes(serialize($album))."&amp;start=".$start."&amp;end=".$end."&amp;photoperline=".$photoPerLine."\",
\"div\",
\"POST\",
\"adminClear=\"+document.getElementById(\"inputPass\").value);'>";
    
  echo "  <input type='password' id='inputPass' />";
  echo "<input type='submit' />";
  echo "</form>";
  echo "</div>";
}

function createNavigatorButtonLeft($album, $start, $end, $photoPerLine, $admin) {
  print("  <div class='navigatorButton' \n");
  if ($start > 0) {
    print("    id='navigatorButtonLeftOn' \n");
    print("    onClick='javascript:getAjaxFile(\n
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=createList&amp;serializedalbum=".addslashes(serialize($album))."&amp;start=".($start - ($end - $start))."&amp;end=".$start."&amp;photoperline=".$photoPerLine."&amp;admin=".$admin."\",\n
\"div\",\n
\"POST\",\n
\"admin=".$admin."\");'\n");
  }
  else {
    print("    id='navigatorButtonLeftOff' \n");
  }
  print(" ></div>");
}

function createParentAlbum($parent, $start, $end, $photoPerLine, $admin) {
  print("    <div class='photo' id='photoAlbum' 
onmouseout='javascript:zoomThumbnail(\"albumParent\", 150, 150, 5)' 
onmouseover='javascript:zoomThumbnail(\"albumParent\", 160, 160, 0)'
onclick='javascript:
displayLoad(\"listPhoto\");
getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=createList&amp;serializedalbum=".addslashes(serialize($parent))."&amp;start=0&amp;end=".($end - $start)."&amp;photoperline=".$photoPerLine."&amp;admin=".$admin."\",
\"div\",
\"POST\",
\"admin=".$admin."\");' >\n");

    print("      <img class='imgPhoto' id='albumParent' 
src='".Parameter::$relativeIncludesPath."/includes/data/photo/thumbnail/parent.jpg' 
alt='".htmlentities($parent->name)."' />\n");
    print("      <div class='titlePhoto' id='titreParent'>".htmlentities($parent->name)."</div>");
    print("    </div>\n");
}

function createPhoto ($i, $photo, $start, $stop, $admin) {
print("<div class='photo' id='photo".$i."' 
onmouseout='javascript:zoomThumbnail(\"img".$i."\", 150, 150, 5)' 
onmouseover='javascript:zoomThumbnail(\"img".$i."\", 160, 160, 0)' ");
      if($admin != Parameter::$adminPass)
	print ("onclick='javascript:displayBigSizePhoto(
\"big\", 
".$start.",
".$stop.",
\"".addslashes(serialize($photo))."\",
".$i.",
\"".htmlentities($photo->GetPath())."\", 
".$photo->width.", 
".$photo->height.", 
100);' ");

      print(">\n");

      print("      <img class='imgPhoto' id='img".$i."' "); 
      if($admin == Parameter::$adminPass)
	print (" onclick='javascript:displayBigSizePhoto(
\"big\", 
".$start.",
".$stop.",
\"".addslashes(serialize($photo))."\",
".$i.",
\"".htmlentities($photo->GetPath())."\", 
".$photo->width.", 
".$photo->height.", 
100);' ");
      
      print (" src='".htmlentities($photo->GetThumbnailPath())."' alt='photo ".htmlentities($photo->GetThumbnailPath())."' />\n");
      print ("      <div class='titlePhoto' id='titre".$i."'>".htmlentities($photo->name));
      if($admin == Parameter::$adminPass)
	print("<a href='javascript:getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=generateThumbnails&amp;serializedalbum=".addslashes(serialize($photo->album))."&amp;start=".$i."&amp;end=1\",
null,
\"GET\",
null, null);
'><img src='".Parameter::$relativeIncludesPath."/includes/data/img/new_thumbnail.png' alt='gen'/></a>");
      print("</div>\n");
      print("    </div>\n");
}

function createAlbum($i, $album, $start, $end, $photoPerLine, $admin) {
  print("    <div class='photo' id='photo".$i."' 
onmouseout='javascript:zoomThumbnail(\"img".$i."\", 150, 150, 5)' 
onmouseover='javascript:zoomThumbnail(\"img".$i."\", 160, 160, 0)' ");
  if ($admin != Parameter::$adminPass)
    print(" onclick='javascript:displayLoad(\"listPhoto\");
getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=createList&amp;serializedalbum=".addslashes(serialize($album))."&amp;start=0&amp;end=".($end - $start)."&amp;photoperline=".$photoPerLine."&amp;admin=".$admin."\",
\"div\",
\"POST\",
\"admin=".$admin."\");' ");
  
  print ("style='width : 150px; height : 150px; margin : 5px;' >\n");
  print("      <img class='imgPhoto' id='img".$i."' ");  
  if ($admin == Parameter::$adminPass)
    print(" onclick='javascript:displayLoad(\"listPhoto\");
getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=createList&amp;serializedalbum=".addslashes(serialize($album))."&amp;start=0&amp;end=".($end - $start)."&amp;photoperline=".$photoPerLine."&amp;admin=".$admin."\",
\"div\",
\"POST\",
\"admin=".$admin."\");'");
  print(" src='".Parameter::$relativeIncludesPath."/includes/data/photo/thumbnail/folder.jpg' 
alt='lp".$album->name."' />\n");
  print("      <div class='titlePhoto' id='titre".$i."'>".htmlentities($album->name));
  if ($admin == Parameter::$adminPass)
    print(" <a href='javascript:getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=generateThumbnails&amp;serializedalbum=".addslashes(serialize($album))."&amp;start=-1&amp;end=-1\",
null,
\"GET\",
null, null);
'><img src='".Parameter::$relativeIncludesPath."/includes/data/img/new_thumbnail.png' alt='gen'/></a>");
  
  print("</div>");
  print("    </div>\n");
}

function createNavigationButtonRight($album, $start, $end, $photoPerLine, $nbPhoto, $admin) {
  print("  <div class='navigatorButton'\n");
  if($end <= $nbPhoto) {
    print("    id='navigatorButtonRightOn'\n");
    print("    onClick='javascript:getAjaxFile(
\"".Parameter::$relativeIncludesPath."/includes/php/interfaces/functions.php?method=createList&amp;serializedalbum=".addslashes(serialize($album))."&amp;start=".$end."&amp;end=".($end + ($end - $start))."&amp;photoperline=".$photoPerLine."&amp;admin=".$admin."\",
\"div\",
\"POST\",
\"admin=".$admin."\");'");
  }
  else {
    print("    id='navigatorButtonRightOff' \n");
  }
  print(" ></div>\n");
}

function createList($album, $start, $end, $photoPerLine, $admin) {
  // 162 = 2*taille bordure + 2 * margin + largeur image
  $width = ($photoPerLine * 162) + 40;
  // recupération de la liste des photos (tableau d'objet Photo ou Album)
  $listPathPhoto = getListPhoto($album);
  // détermination de l'index de fin d'affichage
  $stop = 0;
  if ($end > count($listPathPhoto)) {
    $stop = count($listPathPhoto);
  }
  else {
    $stop = count($listPathPhoto) - (count($listPathPhoto) - $end);
  }
  
  print("<div id='listPhoto' style='width : ".$width."px;'>\n");
  
  // bouton navigation precedent
  createNavigatorButtonLeft($album, $start, $end, $photoPerLine, $admin);
  
  // start div thumbnail
  print("  <div style='float : left; width : ".($width - 40)."px;'>");  
  if ($album->parent != null) {
    createParentAlbum($album->parent, $start, $end, $photoPerLine, $admin);
  }
  for ($i = $start; $i < $stop; $i++) {
    if (get_class($listPathPhoto[$i]) == "Photo") {
      createPhoto ($i, $listPathPhoto[$i], $start, $stop, $admin);
    } else {
      createAlbum($i, $listPathPhoto[$i], $start, $end, $photoPerLine, $admin);
    }
  }
  print("  </div>");
  // end div thumbnail
  
  // bouton navigation suivant
  createNavigationButtonRight($album, $start, $end, $photoPerLine, count($listPathPhoto), $admin);

  // Execution du script de redimensionnement des boutons de navigation
  print("<script type='text/javascript'>ajuste(\"listPhoto\");</script>");
  print("</div>\n");
}

function createExifDataDiv($photo) {
  error_reporting(E_ERROR);
  print("<div id='exifData'>");
  
  $exif = exif_read_data($photo->GetRelativePath(), null, true);

  if($exif !== false) {
    print("<div style='float : left; min-width : 100px;'>");
    if ($exif['IFD0']['ImageDescription'] != "") print($exif['IFD0']['ImageDescription']."<br />");
    else print("<br />");

    if ($exif['IFD0']['Artist'] != "") print($exif['IFD0']['Artist']."<br />");
    else print("<br />");

    if ($exif['IFD0']['Make'] != "") print($exif['IFD0']['Make']." ");

    if($exif['IFD0']['Model'] != "") {
      print($exif['IFD0']['Model']."<br />");
    }
    else print("<br />");

    if ($exif['EXIF']['FNumber'] != "") {
      $f = 0;
      eval("\$f = ".$exif['EXIF']['FNumber'].";");
      print("f/".$f." ");
    }
    
    if ($exif['EXIF']['ExposureTime'] != "") {
      print($exif['EXIF']['ExposureTime']."<br />");
    }
    else print("<br />");
    print("</div>");

    print("<div style='float : left; min-width : 100px;'>");
    if ($exif['EXIF']['ISOSpeedRatings'] != "") print("ISO".$exif['EXIF']['ISOSpeedRatings']);
    else print("<br />");

    if ($exif['EXIF']['FocalLength'] != "") {
      $f = 0;
      eval("\$f = ".$exif['EXIF']['FocalLength'].";");
      print($f."mm<br />");
    }
    else print("<br />");

    if ($exif['EXIF']['DateTimeOriginal'] != "") print($exif['EXIF']['DateTimeOriginal']."<br />");
    else print("<br />");
    print("</div>");
  }
  else print("<div style='float : left;'>Exif indisponible !</div>");
  print("<div style='float:right;'><img src='".$photo->GetHistogramPath()."' /></div>");
  print("</div>");
}
?>
