<?php
function createThumbnail($photo) {
  $Image = $photo->GetRelativePath(); 
  $ratio = 160;
  if($photo->GetType() == ".jpeg" || $photo->GetType() == ".jpg") {
    $src=imagecreatefromjpeg($Image);
  }
  else if ($photo->GetType() == ".png") {
    $src=imagecreatefrompng($Image);
  }
  else {
    return;
  }
  
  $size = getimagesize($Image);
  if ($size[0] > $size[1]) { 
    $im=imagecreatetruecolor($ratio, $ratio);
    imagecopyresampled($im, $src, 0, ($ratio - round($size[1]*($ratio/$size[0]))) / 2 , 0, 0, $ratio, round($size[1]*($ratio/$size[0])), $size[0], $size[1]);  
  }  
  else { 
    $im=imagecreatetruecolor($ratio, $ratio); 
    imagecopyresampled($im, $src, ($ratio - round(($ratio/$size[1])*$size[0])) / 2, 0, 0, 0, round(($ratio/$size[1])*$size[0]),$ratio, $size[0], $size[1]);  
  }  
  
  mkdir ($photo->GetRelativeThumbnailFolder(), 0777, true); 
  ImageJpeg ($im, $photo->GetRelativeThumbnailPath());
}

function createHistogram ($photo) {
  $source_file = $photo->GetRelativePath();

  // histogram options

  $maxheight = 80;
  $barwidth = 0.5;

  if($photo->GetType() == ".jpeg" || $photo->GetType() == ".jpg") {
    $im=imagecreatefromjpeg($source_file);
  }
  else if ($photo->GetType() == ".png") {
    $im=imagecreatefrompng($source_file);
  }
  else {
    return;
  }

  $imgw = imagesx($im);
  $imgh = imagesy($im);

  // n = total number or pixels

  $n = $imgw*$imgh;

  $histo = array();

  for ($i=0; $i<$imgw; $i++)
    {
      for ($j=0; $j<$imgh; $j++)
        {
       
	  // get the rgb value for current pixel
               
	  $rgb = ImageColorAt($im, $i, $j);
               
	  // extract each value for r, g, b
               
	  $r = ($rgb >> 16) & 0xFF;
	  $g = ($rgb >> 8) & 0xFF;
	  $b = $rgb & 0xFF;
               
	  // get the Value from the RGB value
               
	  $V = round(($r + $g + $b) / 3);
               
	  // add the point to the histogram
               
	  $histo[$V] += $V / $n;
       
        }
    }

  // find the maximum in the histogram in order to display a normated graph

  $max = 0;
  for ($i=0; $i<255; $i++)
    {
      if ($histo[$i] > $max)
        {
	  $max = $histo[$i];
        }
    }

  $im = ImageCreate (256*$barwidth, $maxheight) 
    or die ("Erreur lors de la création de l'image");   
  $darkGrey = ImageColorAllocate ($im, 40, 40, 40);      
  $lightGrey = ImageColorAllocate ($im, 122, 122, 122); 
  
  for ($i=0; $i<255; $i++)
    {
      $val += $histo[$i];
      $h = ( $histo[$i]/$max )*$maxheight;
      ImageFilledRectangle ($im, $i*$barwidth, $maxheight, ($i+1) * $barwidth, $maxheight - $h, $lightGrey);
    }
  mkdir ($photo->GetRelativeThumbnailFolder(), 0777, true); 
  ImageJpeg ($im, $photo->GetRelativeHistogramPath());
}
?>
